/* - RFIDAttachListener -
 * Populate the details fields as well as display the attached status.
 * Enable the checkboxes to change the values of the attributes of the RFID
 * reader such as enable or disable the antenna and onboard led.
 *
 * Copyright 2007 Phidgets Inc.  
 * This work is licensed under the Creative Commons Attribution 2.5 Canada License. 
 * To view a copy of this license, visit http://creativecommons.org/licenses/by/2.5/ca/
 */

package listeners;

import com.phidgets.RFIDPhidget;
import com.phidgets.PhidgetException;
import com.phidgets.event.AttachListener;
import com.phidgets.event.AttachEvent;

import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JCheckBox;

public class RFIDAttachListener implements AttachListener{
    
    private JFrame appFrame;
    private JTextField attachedTxt;
    private JTextArea nameTxt;
    private JTextField serialTxt;
    private JTextField versionTxt;
    private JTextField numOutputsTxt;
    private JCheckBox antennaChk;
    private JCheckBox ledChk;
    private JCheckBox out0Chk;
    private JCheckBox out1Chk;
    
    /** Creates a new instance of RFIDAttachListener */
    public RFIDAttachListener(JFrame appFrame, JTextField attachedTxt, JTextArea nameTxt,
            JTextField serialTxt, JTextField versionTxt, JTextField numOutputsTxt,
            JCheckBox antennaChk, JCheckBox ledChk, JCheckBox out0Chk, JCheckBox out1Chk)
    {
        this.appFrame = appFrame;
        this.attachedTxt = attachedTxt;
        this.nameTxt = nameTxt;
        this.serialTxt = serialTxt;
        this.versionTxt = versionTxt;
        this.numOutputsTxt = numOutputsTxt;
        this.antennaChk = antennaChk;
        this.ledChk = ledChk;
        this.out0Chk = out0Chk;
        this.out1Chk = out1Chk;
    }

    public void attached(AttachEvent ae)
    {
        try
        {
            RFIDPhidget attached = (RFIDPhidget)ae.getSource();
            attachedTxt.setText(Boolean.toString(attached.isAttached()));
            nameTxt.setText(attached.getDeviceName());
            serialTxt.setText(Integer.toString(attached.getSerialNumber()));
            versionTxt.setText(Integer.toString(attached.getDeviceVersion()));
            numOutputsTxt.setText(Integer.toString(attached.getOutputCount()));
            
            antennaChk.setEnabled(true);
            attached.setAntennaOn(true);
            antennaChk.setSelected(true);
            ledChk.setEnabled(true);
            ledChk.setSelected(attached.getLEDOn());
            out0Chk.setEnabled(true);
            out0Chk.setSelected(attached.getOutputState(0));
            out1Chk.setEnabled(true);
            out1Chk.setSelected(attached.getOutputState(1));
            
        }
        catch (PhidgetException ex)
        {
            JOptionPane.showMessageDialog(appFrame, ex.getDescription(), "Phidget error " + ex.getErrorNumber(), JOptionPane.ERROR_MESSAGE);
        }
    }
    
}
